#ifndef __QTCLIMAGEVIEWER_H__
#define __QTCLIMAGEVIEWER_H__

#include <QWidget>
#include <QImage>
#include <QtDesigner/QDesignerExportWidget>

class QDESIGNER_WIDGET_EXPORT QTclImageViewer : public QWidget {
  Q_OBJECT
  Q_PROPERTY( QImage image READ image WRITE setImage);
public:
  QTclImageViewer(QWidget *parent=0);
  QImage image() const {return _image;} 
public slots:
  void setImage(const QImage &image);
signals:
  void imageChanged(const QImage &);
protected:
  void paintEvent(QPaintEvent *e);
private:
  QImage   _image;
};

#endif
