#include "QTclSpinListBox.h"

/*!
  \class QTclSpinListBox QSpinBox QTclSpinListBox.h
  \brief An Spinbox with an textlist as content.
  \ingroup basic
  \mainclass
 
  The QTclSpinListBox is an SpinBox to select one of the values
  in an list of strings. The mapping between index and string is 
  very simple: index 0 is string 0 and so on.

  There are simple functions for manipulating the list:
  \code
     append(const QString&) // appends to the list
     remove(const QString&) // removes string from list
  \endcode
  These functions are also slots for convinience.
  
  The propery \e{list} can be set, get and unset. 
*/

/*! \property QTclSpinListBox::list
    \brief the list of strings to map
    
    This propery ist the internal list to map from int 0..len-1 to 
    a string shown in the spinbox.
*/

/*! Constructs a spinlistbox with with parent \a parent and
    name \a name. The list is empty.
*/


QTclSpinListBox::QTclSpinListBox(QWidget *parent):QSpinBox(parent),_list(){
  setMinimum(0);
  setMaximum(0);
}

/*! Overrided virtual QSpinBox function for mapping from int to string */

QString QTclSpinListBox::mapValueToText(int value) {
  if(value<0 || value>=(int)_list.count()) {
    return specialValueText();
  }
  return _list[value];
}

/*! Overrided virtual QSpinBox function for mapping text() to int
   the result is placed in \a ok */

int QTclSpinListBox::mapTextToValue(bool *ok) {
int len=_list.count();
  for(int i=0;i<len;i++) {
    if(_list[i]==text()) {
      *ok=TRUE;
      return i;
    }
  }
  *ok=FALSE;
  return -1;
}

/*! Slot function for appending text to list */

void QTclSpinListBox::append(const QString &text) {
  _list.append(text);
  setMaximum(_list.count());
}

/*! Slot function for removing text from */

void QTclSpinListBox::remove(const QString &text) {
  _list.removeAll(text);
  setMaximum(_list.count());
}

/*! Function for getting the list from the Widget (copy) */

QStringList QTclSpinListBox::list() const {
  return _list;
}

/*! Function for setting the list (copy) */

void QTclSpinListBox::setList(const QStringList &list) {
  _list=list;
  setMaximum(_list.count());
}

void QTclSpinListBox::unsetList() {
  _list.clear();
}

#include "moc_QTclSpinListBox.cpp"
