#ifndef __QSPINLISTBOX__
#define __QSPINLISTBOX__

#include <QSpinBox>
#include <QStringList>
#include <QtDesigner/QDesignerExportWidget>

class QWidget;
class QDESIGNER_WIDGET_EXPORT QTclSpinListBox : public QSpinBox {
  Q_OBJECT
  Q_PROPERTY( QStringList list READ list WRITE setList RESET unsetList )
public:
  QTclSpinListBox(QWidget *parent);
  virtual QString mapValueToText(int value);
  virtual int mapTextToValue(bool *ok);
  QStringList list() const;
public slots:
  void append(const QString &text);
  void remove(const QString &text);
  void setList(const QStringList&);
  void unsetList();
private:
  QStringList _list;
};

#endif
