#include <QtPlugin>

#include "QTclAngleControlPlugin.h"
#include "QTclDOMTreeViewPlugin.h"
#include "QTclImageHistogramPlugin.h"
#include "QTclImageViewerPlugin.h"
#include "QTclSpinListBoxPlugin.h"

#include "QTclWidgetPlugin.h"

QTclWidgetPlugin::QTclWidgetPlugin(QObject *parent):QObject(parent) {
  widgets.append(new QTclAngleControlPlugin(this));
  widgets.append(new QTclDOMTreeViewPlugin(this));
  widgets.append(new QTclImageHistogramPlugin(this));
  widgets.append(new QTclImageViewerPlugin(this));
  widgets.append(new QTclSpinListBoxPlugin(this));
}

QList<QDesignerCustomWidgetInterface*> QTclWidgetPlugin::customWidgets() const {
  return widgets;
}

Q_EXPORT_PLUGIN2(qtclwidgetplugin,QTclWidgetPlugin)
