#!/bin/sh
# the next line restarts using qtcl \
exec qtcl "$0" "$@"

set ui {<!DOCTYPE UI><UI version="3.3" stdsetdef="1">
<class>form1</class>
<widget class="QMainWindow">
    <property name="name">
        <cstring>histogram</cstring>
    </property>
    <property name="caption">
        <string>Histogram</string>
    </property>
    <grid>
        <property name="name">
            <cstring>g1</cstring>
        </property>
        <widget class="QTclImageViewer" row="0" column="0">
            <property name="name">
                <cstring>l1</cstring>
            </property>
        </widget>
        <widget class="QTclImageHistogram" row="1" column="0">
            <property name="name">
                <cstring>h1</cstring>
            </property>
        </widget>
    </grid>
</widget>
<menubar>
    <property name="name">
        <cstring>menu</cstring>
    </property>
    <item text="&amp;File" name="File">
        <action name="fileOpenAction"/>
        <separator/>
        <action name="fileExitAction"/>
    </item>
    <item text="&amp;Help" name="helpMenu">
        <action name="helpAboutAction"/>
    </item>
</menubar>
<toolbars>
</toolbars>
<customwidgets>
</customwidgets>
<actions>
    <action>
        <property name="name">
            <cstring>fileOpenAction</cstring>
        </property>
        <property name="text">
            <string>Open</string>
        </property>
        <property name="menuText">
            <string>&amp;Open...</string>
        </property>
        <property name="accel">
            <string>Ctrl+O</string>
        </property>
    </action>
    <action>
        <property name="name">
            <cstring>fileExitAction</cstring>
        </property>
        <property name="text">
            <string>Exit</string>
        </property>
        <property name="menuText">
            <string>E&amp;xit</string>
        </property>
        <property name="accel">
            <string></string>
        </property>
    </action>
    <action>
        <property name="name">
            <cstring>helpAboutAction</cstring>
        </property>
        <property name="text">
            <string>About</string>
        </property>
        <property name="menuText">
            <string>&amp;About</string>
        </property>
        <property name="accel">
            <string></string>
        </property>
    </action>
</actions>
<connections>
    <connection>
        <sender>h1</sender>
        <signal>imageChanged(const QImage&amp;)</signal>
        <receiver>l1</receiver>
        <slot>setImage(const QImage&amp;)</slot>
    </connection>
    <connection>
        <sender>fileExitAction</sender>
        <signal>activated()</signal>
        <receiver>histogram</receiver>
        <slot>close()</slot>
    </connection>
</connections>
</UI>
}

proc choose {h} {
  qt $h set image [qt QFileDialog getOpenFileName]
}

set top [qt build $ui]
qt .histogram*fileOpenAction bind activated() choose [qt .histogram*h1 name ]
qt $top show
