proc console_status { what msg } {
  qt {.console.automatic status bar} message $what:$msg
}
proc bgerror { msg } { 
  console_status BGERROR $msg
}
qt widget QMainWindow .console
qt widget QWidget .console.f
qt widget QComboBox .console.f.e editable true duplicatesEnabled false
qt widget QTextEdit .console.f.t focusPolicy 0 readOnly true
qt layout QGridLayout .console.f.g
.console.f.g add .console.f.t row 0 column 0
.console.f.g add .console.f.e row 1 column 0
qt {.console.f.e.combo edit} bind returnPressed() {
  set _text [ .console.f.e cget currentText ] 
  .console.f.t append "%% $_text"
  if {[ catch { uplevel #0 $_text } _result ] } {
    .console.f.t append $_result
    console_status ERROR ""
  } else {
    if { [ string length $_result ] } {
      .console.f.t append $_result
    }
    console_status OK ""
  }
  .console.f.t scrollToBottom
  qt {.console.f.e.combo edit} selectAll
  unset _text _result
}
after -200 update idletasks
.console resize 600 400
.console centralWidget .console.f
.console show
