#!/bin/sh
# \
exec qtcl $0 $@

proc bgerror {msg} {
  puts stderr "bgerror:$msg"
  flush stderr
}

proc askForSave {text} {
  if { [ qt [qt $text document ] get modified ] == false } { 
    return true
  }
  set result [qt QMessageBox question parent [qt $text toplevel] caption "Save?" text "Do you want to save your modified file?" button0 Yes button1 No button2 Cancel]
  if { $result == "Cancel" } {
    return false
  }
  if { $result == "No" } {
    return true
  }
  if { $result == "Yes" } {
     return [ fileSave $text ]
  }
  return false
}

proc fileNew {text} {
  if { [ askForSave $text ] == false } {
    return;
  }
  qt $text clear
  qt $text set documentTitle ""
  qt [ qt $text document ] set modified false
}

proc fileSaveAs {text} {
  set filename [qt QFileDialog getSaveFileName]
  if { $filename=="" } {
    return false
  }
  set f [ open $filename w ]
  puts -nonewline $f [qt $text toPlainText]
  close $f
  qt [ qt $text document ] set modified false
  qt $text set documentTitle $filename
  return true
}

proc fileSave {text} {
  set filename [qt $text get documentTitle]
  puts $filename
  if { $filename=="" } {
    return [fileSaveAs $text]
  }
  set f [ open $filename w ]
  puts -nonewline $f [qt $text toPlainText]
  close $f
  qt [ qt $text document ] set modified false
  return true
}

proc fileOpen {text} {
  if { [ askForSave $text ] == false } {
    return;
  }
  set filename [qt QFileDialog getOpenFileName]
  if { $filename=="" } {
    return
  }
  set f [ open $filename r ]
  qt $text setPlainText [read $f]
  close $f
  qt $text set documentTitle $filename
  qt [ qt $text document ] set modified false
}

proc fileQuit {text} {
  if { [ askForSave $text ] } {
    qt .qtcl closeAllWindows
  }
}

proc mainEvent {receiver event sender } {
  puts stdout "event:R($receiver) E($event) S($sender)"
}

set main [qt load editor.ui]
set text [qt $main*textEdit name]
set clip [qt QApplication clipboard]

qt $text event "mainEvent %1 %2 {%3}"

qt $main*action_New bind triggered() fileNew $text
qt $main*action_Open bind triggered() fileOpen $text
qt $main*action_Save bind triggered() fileSave $text
qt $main*action_SaveAs bind triggered() fileSaveAs $text
qt $main*action_Quit bind triggered() fileQuit $text
qt $main*action_AboutQt connect triggered() .qtcl aboutQt()
qt $main show

