#!/bin/sh
# the next line restarts using ktcl \
exec qtcl "$0" "$@"

proc messageBox {parent level text} {
  set w $parent.message
  qt create QMessageBox $w icon $level text $text 
  qt $w exec
  qt $w destroy
}

proc checkvalues {} {
  set to      [ qt .WriteMail*to get text ]
  set cc      [ qt .WriteMail*cc get text ]
  set bcc     [ qt .WriteMail*bcc get text ]
  set subject [ qt .WriteMail*subject get text ]
  set text    [ qt .WriteMail*text get html ]  
  set to  [ join [ split $to " \t,;" ] , ] 
  set cc  [ join [ split $cc " \t,;" ] , ] 
  set bcc [ join [ split $bcc " \t,;" ] , ] 
  if { $to=="" } {
    messageBox .WriteMail Warning "No Destination"
    return
  }
  if { $subject=="" } {
    messageBox .WriteMail Warning "No Subject"
    qt .WriteMail*subject setFocus 7
    return
  }
  if { $text=="" } {
    messageBox .WriteMail Warning "No Text"
    return
  }
  qt .WriteMail accept
  qt .WriteMail hide
  exec mail -s "$subject" -c "$cc" -b "$bcc" "$to" <<$text
}

qt load composemail.ui
qt .WriteMail*send bind clicked() checkvalues
qt .WriteMail show
