#ifndef _TemperatureModel_h_
#define _TemperatureModel_h_

#include <QtCore>

class TemperatureModel : public QObject {
  Q_OBJECT
  Q_PROPERTY(double temperature READ temperature WRITE setTemperature NOTIFY temperatureChanged);
public:
  TemperatureModel(QObject *parent=0): QObject(parent),_temperature(0.0) {}
  double temperature() const { return _temperature; }
public slots:
  void setTemperature(double temperature) {
    if(temperature!=_temperature) {
      _temperature=temperature;
      emit temperatureChanged(_temperature);
    }
  }
signals:
  void temperatureChanged(double temperature);
private:
  double _temperature;
};

#endif
