#ifndef _TemperatureViewComposed_h_
#define _TemperatureViewComposed_h_

#include <QtGui>

class TemperatureViewComposed : public QFrame {
  Q_OBJECT
  Q_ENUMS(TemperatureUnit);
  Q_PROPERTY(double          temperature READ temperature WRITE setTemperature);
  Q_PROPERTY(TemperatureUnit unit       READ unit       WRITE setUnit);
public:
  enum TemperatureUnit { Kelvin,Celsius,Fahrenheit };
public:
  TemperatureViewComposed(QWidget *parent=0): QFrame(parent),_temperature(0.0),_unit(Kelvin) {
    setFrameShape(QFrame::Box);
    QHBoxLayout* box=new QHBoxLayout(this);
    box->setSpacing(1);
    box->setMargin(0);
    _lcd=new QLCDNumber(this);
    _lcd->setSegmentStyle(QLCDNumber::Flat);
    _lcd->setNumDigits(6);
    _lcd->setFrameShape(QFrame::NoFrame);
    box->addWidget(_lcd);
    _unitCombo=new QComboBox(this);
    _unitCombo->addItem(QString::fromUtf8("°K"));
    _unitCombo->addItem(QString::fromUtf8("°C"));
    _unitCombo->addItem(QString::fromUtf8("°F"));
    box->addWidget(_unitCombo);
    connect(_unitCombo,SIGNAL(currentIndexChanged(int)),this,SLOT(setUnit(int)));
  }
  double temperature() const { return _temperature; }
  TemperatureUnit unit() const { return _unit; }
public slots:
  void setTemperature(double temperature) {
    if(temperature!=_temperature) {
      _temperature=temperature;
      updateTemp();
    }
  }
  void setUnit(TemperatureUnit unit) {
    if(unit!=_unit) {
      _unit=unit;
      updateTemp();
    }
    if(unit!=_unitCombo->currentIndex()) {
      _unitCombo->setCurrentIndex(unit);
    }
  }
private slots:
  void setUnit(int unit) {
    setUnit(TemperatureUnit(unit));
  }
private:
  void updateTemp() {
    switch(_unit) {
      case Kelvin:
        _lcd->display(_temperature);
        break;
      case Celsius:
        _lcd->display(_temperature-273.15);
        break;
      case Fahrenheit:
        _lcd->display(_temperature*1.8-459.67);
        break;
    }
  }
private:
  double _temperature;
  TemperatureUnit _unit;
  QLCDNumber* _lcd;
  QComboBox*  _unitCombo;
};


#endif
