#ifndef _TemperatureViewInherited_h_
#define _TemperatureViewInherited_h_

#include <QtGui>

class TemperatureViewInherited : public QLabel {
  Q_OBJECT
  Q_ENUMS(TemperatureUnit);
  Q_PROPERTY(double          temperature READ temperature WRITE setTemperature);
  Q_PROPERTY(TemperatureUnit unit       READ unit       WRITE setUnit);
public:
  enum TemperatureUnit { Kelvin,Celsius,Fahrenheit };
public:
  TemperatureViewInherited(QWidget *parent=0): QLabel(parent),_temperature(0.0),_unit(Kelvin) {
  }
  double temperature() const { return _temperature; }
  TemperatureUnit unit() const { return _unit; }
public slots:
  void setTemperature(double temperature) {
    if(temperature!=_temperature) {
      _temperature=temperature;
      updateTemp();
    }
  }
  void setUnit(TemperatureUnit unit) {
    if(unit!=_unit) {
      _unit=unit;
      updateTemp();
    }
  }
  void setUnit(int unit) {
    setUnit(TemperatureUnit(unit));
  }
private:
  void updateTemp() {
    switch(_unit) {
      case Kelvin:
        setText(QString::number(_temperature)+QString::fromUtf8(" °K"));
        break;
      case Celsius:
        setText(QString::number(_temperature-273.15)+QString::fromUtf8(" °C"));
        break;
      case Fahrenheit:
        setText(QString::number(_temperature*1.8-459.67)+QString::fromUtf8(" °F"));
        break;
    }
  }
protected:
  virtual void mousePressEvent(QMouseEvent *event) {
    Q_UNUSED(event);
    switch(unit()) {
      case Kelvin:
        setUnit(Celsius);
        break;
      case Celsius:
        setUnit(Fahrenheit);
        break;
      case Fahrenheit:
        setUnit(Kelvin);
        break;
    }
  }
private:
  double _temperature;
  TemperatureUnit _unit;
};


#endif
