#ifndef _TemperatureViewPainted_h_
#define _TemperatureViewPainted_h_

#include <QtGui>

class TemperatureViewPainted : public QFrame {
  Q_OBJECT
  Q_ENUMS(TemperatureUnit);
  Q_PROPERTY(double          temperature READ temperature WRITE setTemperature);
  Q_PROPERTY(TemperatureUnit unit       READ unit       WRITE setUnit);
public:
  enum TemperatureUnit { Kelvin,Celsius,Fahrenheit };
public:
  TemperatureViewPainted(QWidget *parent=0): QFrame(parent),_temperature(0.0),_unit(Kelvin) {
    setFrameShape(QFrame::Box);
    setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::Minimum);
    setMinimumSize(fontMetrics().width("000.00 °K"),fontMetrics().height());
  }
  virtual double temperature() const { return _temperature; }
  virtual TemperatureUnit unit() const { return _unit; }
public slots:
  virtual void setTemperature(double temperature) {
    if(temperature!=_temperature) {
      _temperature=temperature;
      update();
    }
  }
  virtual void setUnit(TemperatureUnit unit) {
    if(unit!=_unit) {
      _unit=unit;
      update();
    }
  }
protected:
  virtual void paintEvent(QPaintEvent *event) {
    QPainter p(this);
    QFrame::paintEvent(event);
    p.drawText(rect(),Qt::AlignRight,displayString());
  }
  virtual void mousePressEvent(QMouseEvent *event) {
    Q_UNUSED(event);
    switch(unit()) {
      case Kelvin:
        setUnit(Celsius);
        break;
      case Celsius:
        setUnit(Fahrenheit);
        break;
      case Fahrenheit:
        setUnit(Kelvin);
        break;
    }
  }
public:
  virtual QString displayString() {
    switch(unit()) {
      case Kelvin:
        return QString::number(temperature())+QString::fromUtf8(" °K");
      case Celsius:
        return QString::number(temperature()-273.15)+QString::fromUtf8(" °C");
      case Fahrenheit:
        return QString::number(temperature()*1.8-459.67)+QString::fromUtf8(" °F");
    }
    return QString();
  }
private:
  double _temperature;
  TemperatureUnit _unit;
};


#endif
