#include <QtGui>

#include "TemperatureViewComposed.h"
#include "TemperatureViewPainted.h"
#include "TemperatureViewInherited.h"
#include "TemperatureModel.h"

int main(int argc,char *argv[]) {
QApplication* app=new QApplication(argc,argv);
  // build up model and connect
  TemperatureModel *model=new TemperatureModel(app);
  // build gui
  QDialog* dialog=new QDialog();
  QGridLayout *grid=new QGridLayout(dialog);

  QDoubleSpinBox *spinbox=new QDoubleSpinBox(dialog);
  spinbox->setMaximum(1000.0);
  grid->addWidget(spinbox,0,0);
  QObject::connect(spinbox,SIGNAL(valueChanged(double)),model,SLOT(setTemperature(double)));

  TemperatureViewComposed *view1=new TemperatureViewComposed(dialog);
  view1->setUnit(TemperatureViewComposed::Celsius);
  grid->addWidget(view1,1,0);
  QObject::connect(model,SIGNAL(temperatureChanged(double)),view1,SLOT(setTemperature(double)));

  TemperatureViewPainted *view2=new TemperatureViewPainted(dialog);
  view2->setUnit(TemperatureViewPainted::Kelvin);
  grid->addWidget(view2,2,0);
  QObject::connect(model,SIGNAL(temperatureChanged(double)),view2,SLOT(setTemperature(double)));

  TemperatureViewInherited *view3=new TemperatureViewInherited(dialog);
  view3->setUnit(TemperatureViewInherited::Celsius);
  grid->addWidget(view3,3,0);
  QObject::connect(model,SIGNAL(temperatureChanged(double)),view3,SLOT(setTemperature(double)));

  spinbox->setValue(310.1);

  dialog->show();
  return app->exec();
}
